// Seleccionar elementos del DOM
const formNewCliente = document.getElementById("formNewCliente");
const enviar = document.getElementById("enviar");
const cancelar = document.getElementById("cancelar");
const resetear = document.getElementById("resetear");

// Agregar eventos a los elementos
enviar.addEventListener("click", handleSubmit);
cancelar.addEventListener("click", handleCancel);
resetear.addEventListener("click", handleReset);

// Función principal al enviar el formulario
function handleSubmit() {
    if (formValid()) {
        const formData = new FormData(formNewCliente);

        fetch("/cliente/nuevo", {
            method: "POST",
            body: formData,
        })
            .then(handleResponse)
            .catch(handleError);
    } else {
        formValidAlert();
    }
}

// Función para manejar la respuesta del servidor
function handleResponse(response) {
    console.log(response.status);

    switch (response.status) {
        case 200:
            handleSuccess();
            break;
        case 203:
            console.log("Codigo " + response.status + ": La solicitud fue exitosa");
            break;
        case 404:
            throw new Error("Recurso no encontrado");
        case 500:
            throw new Error("Error del servidor");
        default:
            throw new Error("Error no manejado: " + response.status);
    }
}

// Función para manejar errores en la solicitud Fetch
function handleError(error) {
    console.error("Error:", error);
}

// Función para mostrar un diálogo de éxito
function handleSuccess() {
    const mainNewCliente = document.getElementById("mainNewCliente");
    const newClienteSuccess = '<div class="cliente-success"><span>Cliente creado con éxito</span></div>';
    mainNewCliente.innerHTML = newClienteSuccess;

    setTimeout(() => {
        window.close();
        if (window.opener && !window.opener.closed) {
            window.opener.location.reload();
        }
    }, 2000);
}

// Función para validar el formulario
function formValid() {
    // Implementa tu lógica de validación aquí
    return true;
}

// Función para mostrar un diálogo de alerta si el formulario no es válido
function formValidAlert() {
    const dialogo = document.getElementById("miDialogo");
    const ordenRespuesta = document.getElementById("ordenRespuesta");

    ordenRespuesta.textContent = "Formulario Incompleto";
    dialogo.showModal();

    const cerrarBoton = document.getElementById("cerrarDialogo");
    cerrarBoton.addEventListener("click", () => dialogo.close());
}

// Función para cancelar el formulario
function handleCancel() {
    window.close();
    opener.location.reload();
}

// Función para resetear el formulario
function handleReset() {
    formNewCliente.reset();
}
